/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.unifieddiff;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.unifieddiff.UnifiedDiff;
import com.github.difflib.unifieddiff.UnifiedDiffFile;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnifiedDiffWriter {
    private static final Logger LOG = Logger.getLogger(UnifiedDiffWriter.class.getName());

    public static void write(UnifiedDiff diff, Function<String, List<String>> originalLinesProvider, Writer writer, int contextSize) throws IOException {
        UnifiedDiffWriter.write(diff, originalLinesProvider, (String line) -> {
            try {
                writer.append((CharSequence)line).append("\n");
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }, contextSize);
    }

    public static void write(UnifiedDiff diff, Function<String, List<String>> originalLinesProvider, Consumer<String> writer, int contextSize) throws IOException {
        writer.accept(diff.getHeader());
        for (UnifiedDiffFile file : diff.getFiles()) {
            ArrayList<AbstractDelta<String>> patchDeltas = new ArrayList<AbstractDelta<String>>(file.getPatch().getDeltas());
            if (patchDeltas.isEmpty()) continue;
            UnifiedDiffWriter.writeOrNothing(writer, file.getDiffCommand());
            if (file.getIndex() != null) {
                writer.accept("index " + file.getIndex());
            }
            if (file.getFromFile() != null) {
                writer.accept("--- " + file.getFromFile());
            }
            if (file.getToFile() != null) {
                writer.accept("+++ " + file.getToFile());
            }
            List<String> originalLines = originalLinesProvider.apply(file.getFromFile());
            ArrayList<AbstractDelta<String>> deltas = new ArrayList<AbstractDelta<String>>();
            AbstractDelta delta = (AbstractDelta)patchDeltas.get(0);
            deltas.add(delta);
            if (patchDeltas.size() > 1) {
                for (int i = 1; i < patchDeltas.size(); ++i) {
                    int position = delta.getSource().getPosition();
                    AbstractDelta nextDelta = (AbstractDelta)patchDeltas.get(i);
                    if (position + delta.getSource().size() + contextSize >= nextDelta.getSource().getPosition() - contextSize) {
                        deltas.add(nextDelta);
                    } else {
                        UnifiedDiffWriter.processDeltas(writer, originalLines, deltas, contextSize);
                        deltas.clear();
                        deltas.add(nextDelta);
                    }
                    delta = nextDelta;
                }
            }
            UnifiedDiffWriter.processDeltas(writer, originalLines, deltas, contextSize);
        }
        if (diff.getTail() != null) {
            writer.accept("--");
            writer.accept(diff.getTail());
        }
    }

    private static void processDeltas(Consumer<String> writer, List<String> origLines, List<AbstractDelta<String>> deltas, int contextSize) {
        int line;
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        AbstractDelta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getSource().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getTarget().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getSource().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getSource().getPosition(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        UnifiedDiffWriter.getDeltaText(txt -> buffer.add((String)txt), curDelta);
        origTotal += curDelta.getSource().getLines().size();
        revTotal += curDelta.getTarget().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            AbstractDelta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < nextDelta.getSource().getPosition(); ++line) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
            }
            UnifiedDiffWriter.getDeltaText(txt -> buffer.add((String)txt), nextDelta);
            origTotal += nextDelta.getSource().getLines().size();
            revTotal += nextDelta.getTarget().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        writer.accept("@@ -" + origStart + "," + origTotal + " +" + revStart + "," + revTotal + " @@");
        buffer.forEach(txt -> writer.accept((String)txt));
    }

    private static void getDeltaText(Consumer<String> writer, AbstractDelta<String> delta) {
        for (String line : delta.getSource().getLines()) {
            writer.accept("-" + line);
        }
        for (String line : delta.getTarget().getLines()) {
            writer.accept("+" + line);
        }
    }

    private static void writeOrNothing(Consumer<String> writer, String str) throws IOException {
        if (str != null) {
            writer.accept(str);
        }
    }
}

