/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.action;

import java.awt.Window;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.WrappedSQLException;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mssql.gui.GenerateSqlDialog;
import net.sourceforge.squirrel_sql.plugins.mssql.util.MssqlIntrospector;

public class GenerateSqlCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GenerateSqlCommand.class);
    private ISession _session;
    private final MssqlPlugin _plugin;
    private final IDatabaseObjectInfo[] _dbObjs;

    public GenerateSqlCommand(ISession session, MssqlPlugin plugin, IDatabaseObjectInfo[] dbObjs) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("MssqlPlugin == null");
        }
        if (dbObjs == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo[] is null");
        }
        this._session = session;
        this._plugin = plugin;
        this._dbObjs = dbObjs;
    }

    public void execute() throws BaseException {
        try {
            SQLDriverProperty[] props = this._session.getSQLConnection().getConnectionProperties().getDriverProperties();
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equals("DBNAME") || props[i].getValue().equals(this._session.getSQLConnection().getCatalog())) continue;
                String[] params = new String[]{props[i].getValue(), this._session.getSQLConnection().getCatalog()};
                this._session.getApplication().showErrorDialog(s_stringMgr.getString("mmsql.catalogErr", params));
                return;
            }
            GenerateSqlDialog dlog = new GenerateSqlDialog(this._session, this._plugin, this._dbObjs);
            dlog.preselectObjects(this._dbObjs);
            dlog.pack();
            GUIUtils.centerWithinParent((Window)dlog);
            if (!dlog.showGeneralSqlDialog()) {
                return;
            }
            JFileChooser fc = new JFileChooser();
            if (dlog.getOneFile()) {
                ExtensionFilter ef = new ExtensionFilter();
                ef.addExtension(s_stringMgr.getString("mmsql.sqlScripts"), "sql");
                ef.addExtension(s_stringMgr.getString("mmsql.textFiles"), "txt");
                fc.setFileFilter((FileFilter)ef);
            } else {
                fc.setFileSelectionMode(1);
            }
            if (fc.showSaveDialog(null) == 0) {
                FileWriter fw = null;
                if (dlog.getOneFile()) {
                    fw = new FileWriter(fc.getSelectedFile(), false);
                    if (dlog.getScriptDatabase()) {
                        fw.write(MssqlIntrospector.generateCreateDatabaseScript(this._session.getSQLConnection().getCatalog(), this._session.getSQLConnection()));
                    }
                    if (dlog.getScriptUsersAndRoles()) {
                        fw.write(MssqlIntrospector.generateUsersAndRolesScript(this._session.getSQLConnection().getCatalog(), this._session.getSQLConnection()));
                    }
                }
                ArrayList<IDatabaseObjectInfo> objs = dlog.getSelectedItems();
                for (int i = 0; i < objs.size(); ++i) {
                    String script;
                    IDatabaseObjectInfo oi = objs.get(i);
                    if (!dlog.getOneFile()) {
                        fw = new FileWriter(fc.getSelectedFile() + File.separator + MssqlIntrospector.getFixedVersionedObjectName(oi.getSimpleName()) + ".txt", false);
                    }
                    if (dlog.getGenerateDrop()) {
                        fw.write(MssqlIntrospector.generateDropScript(oi));
                    }
                    if (dlog.getGenerateCreate()) {
                        script = MssqlIntrospector.generateCreateScript(oi, this._session.getSQLConnection(), dlog.getScriptConstraints());
                        fw.write(script);
                    }
                    if (dlog.getScriptIndexes()) {
                        script = MssqlIntrospector.generateCreateIndexesScript(oi, this._session.getSQLConnection());
                        fw.write(script);
                    }
                    if (dlog.getScriptTriggers()) {
                        script = MssqlIntrospector.generateCreateTriggersScript(oi, this._session.getSQLConnection());
                        fw.write(script);
                    }
                    if (dlog.getScriptPermissions()) {
                        script = MssqlIntrospector.generatePermissionsScript(oi, this._session.getSQLConnection());
                        fw.write(script);
                    }
                    if (dlog.getOneFile()) continue;
                    fw.close();
                }
                if (dlog.getOneFile()) {
                    fw.close();
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new WrappedSQLException(ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this._session.getApplication().showErrorDialog(Utilities.getExceptionStringSave((Throwable)ex));
        }
    }
}

