/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.BaseMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MonitorPanel
extends BaseMainPanelTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MonitorPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(MonitorPanel.class);
    private Connection _conn = null;
    private Date _refreshDate;
    private JPanel _mainPanel;
    private JSlider _frequency = null;
    private IDataSetViewer _whoViewer;
    private CallableStatement _whoStmt = null;
    private ResultSetDataSet _whoDataSet = null;
    private IDataSetViewer _perfViewer;
    private PreparedStatement _perfStmt = null;
    private ResultSetDataSet _perfDataSet = null;
    private CallableStatement _monitorStmt = null;
    private Timer _refreshTimer = null;
    private boolean _haveSession = false;
    private boolean _inRefresh = false;

    public Component getComponent() {
        if (this._mainPanel == null) {
            this._mainPanel = this.buildMainPanel();
            this._refreshTimer = new Timer(this._frequency.getValue(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!MonitorPanel.this._haveSession) {
                        return;
                    }
                    if (MonitorPanel.this._inRefresh) {
                        return;
                    }
                    MonitorPanel.this._inRefresh = true;
                    MonitorPanel.this.refreshData();
                    MonitorPanel.this._inRefresh = false;
                }
            });
        }
        return this._mainPanel;
    }

    public String getHint() {
        return s_stringMgr.getString("mssql.activity");
    }

    public String getTitle() {
        if (this._refreshDate == null) {
            return s_stringMgr.getString("mssql.monitor");
        }
        return s_stringMgr.getString("mssql.monitorAsOf", new Object[]{this._refreshDate});
    }

    protected void refreshComponent() {
        if (!this._haveSession) {
            try {
                this._conn = this.getSession().getSQLConnection().getConnection();
                this._whoStmt = this._conn.prepareCall("{ call sp_who }");
                this._whoDataSet = new ResultSetDataSet();
                this._perfStmt = this._conn.prepareStatement("SELECT * FROM master.dbo.sysperfinfo");
                this._perfDataSet = new ResultSetDataSet();
                this._monitorStmt = this._conn.prepareCall("{ call sp_monitor }");
                this._haveSession = true;
            }
            catch (SQLException ex) {
                s_log.error((Object)("Unexpected exception: " + ex.getMessage()), (Throwable)ex);
            }
        }
        this.refreshData();
    }

    private void refreshData() {
        try {
            this._refreshDate = new Date();
            ResultSet rs = this._whoStmt.executeQuery();
            this._whoDataSet.setResultSet(rs, DialectType.MSSQL);
            this._whoViewer.show((IDataSet)this._whoDataSet);
            rs = this._perfStmt.executeQuery();
            this._perfDataSet.setResultSet(rs, DialectType.MSSQL);
            this._perfViewer.show((IDataSet)this._perfDataSet);
        }
        catch (SQLException ex) {
            s_log.error((Object)("Unexpected exception: " + ex.getMessage()), (Throwable)ex);
        }
        catch (DataSetException dse) {
            s_log.error((Object)("Unexpected exception: " + dse.getMessage()), (Throwable)dse);
        }
    }

    private JPanel buildMainPanel() {
        SessionProperties props = this.getSession().getProperties();
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        this._frequency = new JSlider();
        this._frequency.setMinimum(0);
        this._frequency.setMaximum(20);
        this._frequency.setValue(0);
        this._frequency.setMajorTickSpacing(2);
        this._frequency.setMinorTickSpacing(1);
        this._frequency.setPaintLabels(true);
        this._frequency.setPaintTicks(true);
        this._frequency.setSnapToTicks(true);
        this._frequency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (slider.getValue() == 0) {
                    if (MonitorPanel.this._refreshTimer.isRunning()) {
                        MonitorPanel.this._refreshTimer.stop();
                    }
                } else {
                    MonitorPanel.this._refreshTimer.setDelay(slider.getValue() * 1000);
                    if (!MonitorPanel.this._refreshTimer.isRunning()) {
                        MonitorPanel.this._refreshTimer.start();
                    }
                }
                slider.setToolTipText(s_stringMgr.getString("mssql.delay", new Object[]{slider.getValue()}));
            }
        });
        this.addComponentToGridBag(0, 0, 1, 1, 0.0, 0.0, 1, gridBag, this._frequency, panel);
        JButton refreshButton = new JButton(s_stringMgr.getString("mssql.refreshNow"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MonitorPanel.this._haveSession) {
                    return;
                }
                if (MonitorPanel.this._inRefresh) {
                    return;
                }
                MonitorPanel.this._inRefresh = true;
                MonitorPanel.this.refreshData();
                MonitorPanel.this._inRefresh = false;
            }
        });
        this.addComponentToGridBag(-1, 0, 1, 1, 0.0, 0.0, 0, gridBag, refreshButton, panel);
        this._whoViewer = BaseDataSetViewerDestination.createInstance((String)props.getReadOnlySQLResultsOutputClassName(), null, null);
        JScrollPane whoScroll = new JScrollPane(this._whoViewer.getComponent());
        whoScroll.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("mssql.currentActivity")));
        this.addComponentToGridBag(0, 1, 1, 1, 1.0, 1.0, 1, gridBag, whoScroll, panel);
        this._perfViewer = BaseDataSetViewerDestination.createInstance((String)props.getReadOnlySQLResultsOutputClassName(), null, null);
        JScrollPane perfScroll = new JScrollPane(this._perfViewer.getComponent());
        perfScroll.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("mssql.performace")));
        this.addComponentToGridBag(-1, 1, 1, 1, 1.0, 1.0, 1, gridBag, perfScroll, panel);
        return panel;
    }

    private void addComponentToGridBag(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, GridBagLayout gridBag, Component component, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.fill = fill;
        c.weightx = weightx;
        c.weighty = weighty;
        gridBag.setConstraints(component, c);
        container.add(component);
    }

    public SQLPanel getSqlPanelOrNull() {
        return null;
    }
}

