/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.util;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mssql.util.MssqlIntrospector;

public class DatabaseObjectInfoRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof IDatabaseObjectInfo) {
            String gif;
            IDatabaseObjectInfo oi = (IDatabaseObjectInfo)value;
            String simpleName = oi.getSimpleName();
            int mssqlType = MssqlIntrospector.getObjectInfoType(oi);
            switch (mssqlType) {
                case 1: {
                    gif = "properties.gif";
                    break;
                }
                case 2: {
                    gif = "arraypartition_obj.gif";
                    break;
                }
                case 3: {
                    simpleName = simpleName.replaceAll(";0", "");
                    gif = "thread_view.gif";
                    break;
                }
                case 4: {
                    simpleName = simpleName.replaceAll(";1", "");
                    gif = "variable_tab.gif";
                    break;
                }
                case 5: {
                    gif = "type.gif";
                    break;
                }
                default: {
                    gif = "error_co.gif";
                }
            }
            URL url = MssqlPlugin.class.getResource("resources/icons/eclipse/" + gif);
            if (url != null) {
                this.setText(simpleName);
                this.setIcon(new ImageIcon(url, oi.getDatabaseObjectType().toString()));
                return this;
            }
            return null;
        }
        return null;
    }
}

