/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecutor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.postgres.IObjectTypes;
import net.sourceforge.squirrel_sql.plugins.postgres.PostgresSQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.postgres.actions.VacuumDatabaseAction;
import net.sourceforge.squirrel_sql.plugins.postgres.actions.VacuumTableAction;
import net.sourceforge.squirrel_sql.plugins.postgres.exp.PostgresSequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.exp.PostgresTableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.postgres.exp.PostgresTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.postgres.explain.ExplainExecutorPanel;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.ActiveConnections;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.IndexSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.LockTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlArrayTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlGeometryTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlOtherTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlUUIDTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlXmlTypeDataTypeComponentFactory;

public class PostgresPlugin
extends DefaultSessionPlugin
implements ISQLDatabaseMetaDataFactory {
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private static final ILogger s_log = LoggerController.createLogger(PostgresPlugin.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PostgresPlugin.class);

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "postgres";
    }

    public String getDescriptiveName() {
        return "Postgres Plugin";
    }

    public String getVersion() {
        return "0.22";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Daniel Regli, Yannick Winiger, Jaros\u0142aw Jarmo\u0142owicz";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        ActionCollection col = this.getApplication().getActionCollection();
        col.add((Action)((Object)new VacuumTableAction(app, this._resources)));
        col.add((Action)((Object)new VacuumDatabaseAction(app, this._resources)));
        JMenu sessionMenu = this.createSessionMenu(col);
        app.addToMenu(2, sessionMenu);
        super.registerSessionMenu(sessionMenu);
        PostgreSqlGeometryTypeDataTypeComponentFactory factory = new PostgreSqlGeometryTypeDataTypeComponentFactory(app.getSessionManager());
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)factory);
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlUUIDTypeDataTypeComponentFactory());
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlArrayTypeDataTypeComponentFactory());
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlXmlTypeDataTypeComponentFactory());
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlOtherTypeDataTypeComponentFactory("interval"));
        SQLDatabaseMetaDataFactory.registerOverride((DialectType)DialectType.POSTGRES, (ISQLDatabaseMetaDataFactory)this);
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        SwingUtilities.invokeLater(() -> session.getSQLPanelAPIOfActiveSessionWindow().addExecutor((ISQLResultExecutor)new ExplainExecutorPanel(session)));
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                SwingUtilities.invokeLater(() -> sqlInternalFrame.getMainSQLPanelAPI().addExecutor((ISQLResultExecutor)new ExplainExecutorPanel(sess)));
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                PostgresPlugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                PostgresPlugin.this.updateTreeApi((IObjectTreeAPI)objectTreePanel);
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
                SwingUtilities.invokeLater(() -> additionalSQLTab.getSQLPanelAPI().addExecutor((ISQLResultExecutor)new ExplainExecutorPanel(additionalSQLTab.getSession())));
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isPostgreSQL((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(IObjectTreeAPI treeAPI) {
        String stmtSep = treeAPI.getSession().getQueryTokenizer().getSQLStatementSeparator();
        ActionCollection col = this.getApplication().getActionCollection();
        treeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new PostgresSequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE));
        TableWithChildNodesExpander tableExpander = new TableWithChildNodesExpander();
        PostgresTableIndexExtractorImpl indexExtractor = new PostgresTableIndexExtractorImpl();
        PostgresTableTriggerExtractorImpl triggerExtractor = new PostgresTableTriggerExtractorImpl();
        tableExpander.setTableTriggerExtractor((ITableTriggerExtractor)triggerExtractor);
        tableExpander.setTableIndexExtractor((ITableIndexExtractor)indexExtractor);
        treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExpander);
        treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE));
        treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep));
        treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexSourceTab(i18n.SHOW_INDEX_SOURCE, stmtSep));
        treeAPI.addDetailTab(IObjectTypes.TRIGGER_PARENT, (IObjectTab)new DatabaseObjectInfoTab());
        treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
        treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE_TYPE_DBO, (IObjectTab)new SequenceDetailsTab());
        treeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new LockTab());
        treeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ActiveConnections());
        JMenu tableMenu = this._resources.createMenu("postgres");
        this._resources.addToMenu(col.get(VacuumTableAction.class), tableMenu);
        treeAPI.addToPopup(DatabaseObjectType.TABLE, tableMenu);
        treeAPI.addToPopup(DatabaseObjectType.SESSION, this.createSessionMenu(col));
    }

    private JMenu createSessionMenu(ActionCollection col) {
        JMenu sessionMenu = this._resources.createMenu("postgres");
        this._resources.addToMenu(col.get(VacuumDatabaseAction.class), sessionMenu);
        return sessionMenu;
    }

    public SQLDatabaseMetaData fetchMeta(ISQLConnection conn) {
        return new PostgresSQLDatabaseMetaData(conn);
    }

    public static interface IMenuResourceKeys {
        public static final String POSTGRES = "postgres";
    }

    static interface i18n {
        public static final String SHOW_INDEX_SOURCE = s_stringMgr.getString("PostgresPlugin.showIndexSource");
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("PostgresPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = s_stringMgr.getString("PostgresPlugin.showProcedureSource");
    }
}

