/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class PostgresSQLDatabaseMetaData
extends SQLDatabaseMetaData {
    private static final ILogger s_log = LoggerController.createLogger(PostgresSQLDatabaseMetaData.class);
    private final ISQLConnection _conn;
    private Map<String, Boolean> oidSupportForTable;

    public PostgresSQLDatabaseMetaData(ISQLConnection conn) {
        super(conn);
        this._conn = conn;
        this.oidSupportForTable = new HashMap<String, Boolean>();
    }

    public String getOptionalPseudoColumnForDataSelection(ITableInfo ti) {
        Boolean supports = this.oidSupportForTable.get(ti.getQualifiedName());
        if (supports == null) {
            supports = false;
            try {
                ResultSet rs = this._conn.createStatement().executeQuery("SELECT TRUE FROM   pg_attribute WHERE  attrelid = '" + ti.getQualifiedName() + "'::regclass AND    attname = 'oid' AND NOT attisdropped");
                if (rs.next()) {
                    supports = true;
                }
            }
            catch (SQLException sqlE) {
                s_log.error((Object)"During oid existance checking", (Throwable)sqlE);
            }
            this.oidSupportForTable.put(ti.getQualifiedName(), supports);
        }
        return supports != false ? "oid" : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getDataTypesSimpleNames() throws SQLException {
        String sql = "SELECT t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid)  WHERE n.nspname != 'pg_toast'  AND typelem = 0 AND typrelid = 0";
        ArrayList<String> retn = new ArrayList<String>();
        ResultSet rs = this._conn.createStatement().executeQuery(sql);
        try {
            while (rs.next()) {
                retn.add(rs.getString(1));
            }
        }
        finally {
            SQLUtilities.closeResultSet((ResultSet)rs);
        }
        return retn.toArray(new String[retn.size()]);
    }
}

