/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.commands.handler;

import java.sql.SQLWarning;
import java.util.ArrayList;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.IProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.gui.ProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.SQLExecutionException;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class ProgressSQLExecuterHandler
implements ISQLExecuterHandler {
    protected ISession _session;
    protected ProgressCallBack _pdialog;
    protected IProgressCallBackFactory progressCallBackFactory = new ProgressCallBackFactory();
    protected String _commandPrefix;
    private static final ILogger s_log = LoggerController.createLogger(ProgressSQLExecuterHandler.class);

    public ProgressSQLExecuterHandler(ISession session, JDialog owner, String progressDialogTitle, String commandPrefix) {
        this._session = session;
        this._pdialog = this.progressCallBackFactory.create(owner, progressDialogTitle, 0);
        this._commandPrefix = commandPrefix;
    }

    public void setProgressCallBackFactory(IProgressCallBackFactory progressCallBackFactory) {
        this.progressCallBackFactory = progressCallBackFactory;
    }

    public void sqlToBeExecuted(QueryHolder queryHolder) {
        block3: {
            if (s_log.isDebugEnabled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    if (!s_log.isDebugEnabled()) break block3;
                    s_log.debug((Object)e);
                }
            }
        }
        this._pdialog.setLoadingPrefix(this._commandPrefix);
        this._pdialog.currentlyLoading(this.getSuffix(queryHolder.getQuery()));
    }

    protected abstract String getSuffix(String var1);

    public void sqlExecutionComplete(SQLExecutionInfo info, int processedStatementCount, int statementCount) {
    }

    public void sqlExecutionWarning(SQLWarning warn) {
        this._session.showMessage((Throwable)warn);
    }

    public void sqlStatementCount(int statementCount) {
        this._pdialog.setTotalItems(statementCount + 1);
    }

    public void sqlExecutionCancelled() {
        this._pdialog.dispose();
    }

    public void sqlDataUpdated(int updateCount) {
    }

    public void sqlResultSetAvailable(ResultSetWrapper rst, SQLExecutionInfo info, IDataSetUpdateableTableModel model) {
    }

    public String sqlExecutionException(Throwable th, String postErrorString) {
        String message = this._session.formatException((Throwable)new SQLExecutionException(th, postErrorString));
        this._session.showErrorMessage(message);
        if (this._session.getProperties().getWriteSQLErrorsToLog()) {
            s_log.info((Object)message);
        }
        this._pdialog.dispose();
        return message;
    }

    public void sqlCloseExecutionHandler(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
    }
}

