/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.ParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class PostgreSqlUUIDTypeDataTypeComponent
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static ILogger s_log = LoggerController.createLogger(PostgreSqlUUIDTypeDataTypeComponent.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PostgreSqlUUIDTypeDataTypeComponent.class);

    public boolean canDoFileIO() {
        return true;
    }

    public String getClassName() {
        return UUID.class.getName();
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"getDefaultValue: not yet implemented");
        }
        return null;
    }

    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new ParameterWhereClausePart(this._colDef, value, (IDataTypeComponent)this);
    }

    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public Object readResultSet(ResultSet rs, int idx, boolean limitDataRead) throws SQLException {
        Object result = null;
        try {
            result = rs.getObject(idx);
            if (result == null) {
                return "<null>";
            }
        }
        catch (Exception e) {
            s_log.error((Object)"Unexpected exception while attempting to read PostgreSQL XML column", (Throwable)e);
        }
        if (result == null) {
            result = i18n.CELL_ERROR_MSG;
        }
        return result;
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, 1111);
        } else {
            try {
                pstmt.setObject(position, value, 1111);
            }
            catch (Exception e) {
                s_log.error((Object)("setPreparedStatementValue: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean areEqual(Object obj1, Object obj2) {
        return obj1.equals(obj2);
    }

    protected String quoteTextConditionValue(String value) {
        return StringUtilities.singleQuote((String)value);
    }

    static interface i18n {
        public static final String CELL_ERROR_MSG = s_stringMgr.getString("PostgreSqlXmlTypeDataTypeComponent.cellErrorMsg");
    }
}

