/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.types;

import java.awt.event.KeyListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.StringFieldKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class PostgreSqlXmlTypeDataTypeComponent
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static ILogger s_log = LoggerController.createLogger(PostgreSqlXmlTypeDataTypeComponent.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PostgreSqlXmlTypeDataTypeComponent.class);

    public boolean canDoFileIO() {
        return true;
    }

    public String getClassName() {
        return "java.lang.String";
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"getDefaultValue: not yet implemented");
        }
        return null;
    }

    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        return super.getWhereClauseValue(value, md);
    }

    public boolean isEditableInCell(Object originalValue) {
        return !i18n.CELL_ERROR_MSG.equals(originalValue);
    }

    public boolean isEditableInPopup(Object originalValue) {
        return !i18n.CELL_ERROR_MSG.equals(originalValue);
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public Object readResultSet(ResultSet rs, int idx, boolean limitDataRead) throws SQLException {
        String result = null;
        try {
            result = rs.getString(idx);
            if (result == null || "".equals(result)) {
                return "<null>";
            }
        }
        catch (Exception e) {
            s_log.error((Object)"Unexpected exception while attempting to read PostgreSQL XML column", (Throwable)e);
        }
        if (result == null) {
            result = i18n.CELL_ERROR_MSG;
        }
        return result;
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null || "".equals(value)) {
            pstmt.setNull(position, 1111, "xml");
        } else {
            try {
                pstmt.setString(position, value.toString());
            }
            catch (Exception e) {
                s_log.error((Object)("setPreparedStatementValue: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean areEqual(Object obj1, Object obj2) {
        return ((String)obj1).equals(obj2);
    }

    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>")) {
            return null;
        }
        return value;
    }

    protected KeyListener getKeyListener(IRestorableTextComponent component) {
        boolean isNullable = false;
        int columnSize = -1;
        if (this._colDef != null) {
            isNullable = this._colDef.isNullable();
            columnSize = this._colDef.getColumnSize();
        }
        return new StringFieldKeyTextHandler(component, columnSize, isNullable, this._beepHelper);
    }

    static interface i18n {
        public static final String CELL_ERROR_MSG = s_stringMgr.getString("PostgreSqlXmlTypeDataTypeComponent.cellErrorMsg");
    }
}

