/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import org.nocrala.tools.utils.Filler;

public class BorderStyle {
    public static final BorderStyle DEMO = new BorderStyle("1a234b567c89xyztu");
    public static final BorderStyle BLANKS = new BorderStyle("                 ");
    public static final BorderStyle DOTS = new BorderStyle(".................");
    public static final BorderStyle ASTERISKS = new BorderStyle("*****************");
    public static final BorderStyle HORIZONTAL_ONLY = new BorderStyle("", "-", " ", "", "", "-", " ", "", "", "-", " ", "", "", " ", "", " ", " ");
    public static final BorderStyle CLASSIC = new BorderStyle("+-+++-+++-++|||--");
    public static final BorderStyle CLASSIC_WIDE = new BorderStyle("+-", "-", "-+-", "-+", "+-", "-", "-+-", "-+", "+-", "-", "-+-", "-+", "| ", " | ", " |", "---", "---");
    public static final BorderStyle CLASSIC_LIGHT = new BorderStyle("+--++--++--+| |--");
    public static final BorderStyle CLASSIC_LIGHT_WIDE = new BorderStyle("+-", "-", "--", "-+", "+-", "-", "--", "-+", "+-", "-", "--", "-+", "| ", "  ", " |", "--", "--");
    public static final BorderStyle CLASSIC_COMPATIBLE = new BorderStyle("+-+++-+++-++!!!--");
    public static final BorderStyle CLASSIC_COMPATIBLE_WIDE = new BorderStyle("+-", "-", "-+-", "-+", "+-", "-", "-+-", "-+", "+-", "-", "-+-", "-+", "! ", " ! ", " !", "---", "---");
    public static final BorderStyle CLASSIC_COMPATIBLE_LIGHT_WIDE = new BorderStyle("+-", "-", "--", "-+", "+-", "-", "--", "-+", "+-", "-", "--", "-+", "! ", "  ", " !", "--", "--");
    public static final BorderStyle HEAVY = new BorderStyle("+==++==++==+|||==");
    public static final BorderStyle HEAVY_TOP_AND_BOTTOM = new BorderStyle("+==++--++==+|||--");
    public static final BorderStyle DESIGN_FORMAL = new BorderStyle("", "=", "=", "", "", "-", " ", "", "", "=", "=", "", "", " ", "", " ", " ");
    public static final BorderStyle DESIGN_FORMAL_INVERSE = new BorderStyle("", "-", "-", "", "", "=", " ", "", "", "-", "-", "", "", " ", "", " ", " ");
    public static final BorderStyle DESIGN_CASUAL = new BorderStyle("", "=", "=", "", "", "~", " ", "", "", "=", "=", "", "", " ", "", " ", " ");
    public static final BorderStyle DESIGN_CAFE = new BorderStyle("", "~", "~", "", "", "~", " ", "", "", "~", "~", "", "", " ", "", " ", " ");
    public static final BorderStyle DESIGN_SLASH = new BorderStyle("", "/", "/", "", "", "-", " ", "", "", "/", "/", "", "", " ", "", " ", " ");
    public static final BorderStyle DESIGN_TUBES = new BorderStyle(" __ |_|||_|||||__");
    public static final BorderStyle DESIGN_DOTS = new BorderStyle("\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7", "\u00b7");
    public static final BorderStyle DESIGN_DIM = new BorderStyle("", "\u00a8", "\u00a8", "", "", "\u00a8", " ", "", "", "\u00a8", "\u00a8", "", "", " ", "", "\u00a8", "\u00a8");
    public static final BorderStyle DESIGN_CURTAIN = new BorderStyle("o~", "~", "~", "~o", "  ", "-", " ", "  ", "o~", "~", "~", "~o", "  ", " ", "  ", " ", " ");
    public static final BorderStyle DESIGN_CURTAIN_HEAVY = new BorderStyle("o=", "=", "=", "=o", "  ", "-", " ", "  ", "o=", "=", "=", "=o", "  ", " ", "  ", " ", " ");
    public static final BorderStyle DESIGN_PAPYRUS = new BorderStyle("o~~~", "~", "~~", "~~~o", " )  ", "~", "  ", "  (", "o~~~", "~", "~~", "~~~o", " )  ", "  ", "  (", "  ", "  ");
    public static final BorderStyle DESIGN_FORMAL_WIDE = new BorderStyle("", "=", "==", "", "", "-", "  ", "", "", "=", "==", "", "", "  ", "", "  ", "  ");
    public static final BorderStyle DESIGN_FORMAL_INVERSE_WIDE = new BorderStyle("", "-", "--", "", "", "=", "  ", "", "", "-", "--", "", "", "  ", "", "  ", "  ");
    public static final BorderStyle DESIGN_CASUAL_WIDE = new BorderStyle("", "=", "==", "", "", "~", "  ", "", "", "=", "==", "", "", "  ", "", "  ", "  ");
    public static final BorderStyle DESIGN_CAFE_WIDE = new BorderStyle("", "~", "~~", "", "", "~", "  ", "", "", "~", "~~", "", "", "  ", "", "  ", "  ");
    public static final BorderStyle DESIGN_SLASH_WIDE = new BorderStyle("", "/", "//", "", "", "-", "  ", "", "", "/", "//", "", "", "  ", "", "  ", "  ");
    public static final BorderStyle DESIGN_TUBES_WIDE = new BorderStyle(" _", "_", "___", "_ ", "|_", "_", "_|_", "_|", "|_", "_", "_|_", "_|", "| ", " | ", " |", "___", "___");
    public static final BorderStyle DESIGN_DOTS_WIDE = new BorderStyle("\u00b7\u00b7", "\u00b7", "\u00b7\u00b7\u00b7", "\u00b7\u00b7", "\u00b7\u00b7", "\u00b7", "\u00b7\u00b7\u00b7", " \u00b7", "\u00b7\u00b7", "\u00b7", "\u00b7\u00b7\u00b7", "\u00b7\u00b7", "\u00b7 ", " \u00b7 ", " \u00b7", "\u00b7\u00b7\u00b7", "\u00b7\u00b7\u00b7");
    public static final BorderStyle DESIGN_DIM_WIDE = new BorderStyle("", "\u00a8", "\u00a8\u00a8", "", "", "\u00a8", "  ", "", "", "\u00a8", "\u00a8\u00a8", "", "", "  ", "", "  ", "  ");
    public static final BorderStyle DESIGN_CURTAIN_WIDE = new BorderStyle("o~", "~", "~~", "~o", "  ", "-", "  ", "  ", "o~", "~", "~~", "~o", "  ", "  ", "  ", "  ", "  ");
    public static final BorderStyle DESIGN_CURTAIN_HEAVY_WIDE = new BorderStyle("o=", "=", "==", "=o", "  ", "-", "  ", "  ", "o=", "=", "==", "=o", "  ", "  ", "  ", "  ", "  ");
    public static final BorderStyle UNICODE_BOX = new BorderStyle("\u250c\u2500\u252c\u2510\u251c\u2500\u253c\u2524\u2514\u2500\u2534\u2518\u2502\u2502\u2502\u2534\u252c");
    public static final BorderStyle UNICODE_ROUND_BOX = new BorderStyle("\u256d\u2500\u252c\u256e\u251c\u2500\u253c\u2524\u2570\u2500\u2534\u256f\u2502\u2502\u2502\u2534\u252c");
    public static final BorderStyle UNICODE_HEAVY_BOX = new BorderStyle("\u250f\u2501\u2533\u2513\u2523\u2501\u254b\u252b\u2517\u2501\u253b\u251b\u2503\u2503\u2503\u253b\u2533");
    public static final BorderStyle UNICODE_BOX_HEAVY_BORDER = new BorderStyle("\u250f\u2501\u252f\u2513\u2520\u2500\u253c\u2528\u2517\u2501\u2537\u251b\u2503\u2502\u2503\u2534\u252c");
    public static final BorderStyle UNICODE_DOUBLE_BOX = new BorderStyle("\u2554\u2550\u2566\u2557\u2560\u2550\u256c\u2563\u255a\u2550\u2569\u255d\u2551\u2551\u2551\u2569\u2566");
    public static final BorderStyle UNICODE_BOX_DOUBLE_BORDER = new BorderStyle("\u2554\u2550\u2564\u2557\u255f\u2500\u253c\u2562\u255a\u2550\u2567\u255d\u2551\u2502\u2551\u2534\u252c");
    public static final BorderStyle UNICODE_BOX_WIDE = new BorderStyle("\u250c\u2500", "\u2500", "\u2500\u252c\u2500", "\u2500\u2510", "\u251c\u2500", "\u2500", "\u2500\u253c\u2500", "\u2500\u2524", "\u2514\u2500", "\u2500", "\u2500\u2534\u2500", "\u2500\u2518", "\u2502 ", " \u2502 ", " \u2502", "\u2500\u2534\u2500", "\u2500\u252c\u2500");
    public static final BorderStyle UNICODE_ROUND_BOX_WIDE = new BorderStyle("\u256d\u2500", "\u2500", "\u2500\u252c\u2500", "\u2500\u256e", "\u251c\u2500", "\u2500", "\u2500\u253c\u2500", "\u2500\u2524", "\u2570\u2500", "\u2500", "\u2500\u2534\u2500", "\u2500\u256f", "\u2502 ", " \u2502 ", " \u2502", "\u2500\u2534\u2500", "\u2500\u252c\u2500");
    public static final BorderStyle UNICODE_HEAVY_BOX_WIDE = new BorderStyle("\u250f\u2501", "\u2501", "\u2501\u2533\u2501", "\u2501\u2513", "\u2523\u2501", "\u2501", "\u2501\u254b\u2501", "\u2501\u252b", "\u2517\u2501", "\u2501", "\u2501\u253b\u2501", "\u2501\u251b", "\u2503 ", " \u2503 ", " \u2503", "\u2501\u253b\u2501", "\u2501\u2533\u2501");
    public static final BorderStyle UNICODE_BOX_HEAVY_BORDER_WIDE = new BorderStyle("\u250f\u2501", "\u2501", "\u2501\u252f\u2501", "\u2501\u2513", "\u2520\u2500", "\u2500", "\u2500\u253c\u2500", "\u2500\u2528", "\u2517\u2501", "\u2501", "\u2501\u2537\u2501", "\u2501\u251b", "\u2503 ", " \u2502 ", " \u2503", "\u2500\u2534\u2500", "\u2500\u252c\u2500");
    public static final BorderStyle UNICODE_DOUBLE_BOX_WIDE = new BorderStyle("\u2554\u2550", "\u2550", "\u2550\u2566\u2550", "\u2550\u2557", "\u2560\u2550", "\u2550", "\u2550\u256c\u2550", "\u2550\u2563", "\u255a\u2550", "\u2550", "\u2550\u2569\u2550", "\u2550\u255d", "\u2551 ", " \u2551 ", " \u2551", "\u2550\u2569\u2550", "\u2550\u2566\u2550");
    public static final BorderStyle UNICODE_BOX_DOUBLE_BORDER_WIDE = new BorderStyle("\u2554\u2550", "\u2550", "\u2550\u2564\u2550", "\u2550\u2557", "\u255f\u2500", "\u2500", "\u2500\u253c\u2500", "\u2500\u2562", "\u255a\u2550", "\u2550", "\u2550\u2567\u2550", "\u2550\u255d", "\u2551 ", " \u2502 ", " \u2551", "\u2500\u2534\u2500", "\u2500\u252c\u2500");
    private String tLCorner;
    private String top;
    private String tCCorner;
    private String tRCorner;
    private String mLCorner;
    private String middle;
    private String mCCorner;
    private String mRCorner;
    private String bLCorner;
    private String bottom;
    private String bCCorner;
    private String bRCorner;
    private String left;
    private String center;
    private String right;
    private String upperColSpan;
    private String lowerColSpan;
    private int leftWidth;
    private int horizontalWidth;
    private int centerWidth;
    private int rightWidth;
    private static final String DEFAULT_TILE = "*";

    public BorderStyle(String tLCorner, String top, String tCCorner, String tRCorner, String mLCorner, String middle, String mCCorner, String mRCorner, String bLCorner, String bottom, String bCCorner, String bRCorner, String left, String center, String right, String upperColSpan, String lowerColSpan) {
        this.leftWidth = this.maxWidth(tLCorner, mLCorner, bLCorner, left);
        this.horizontalWidth = 1;
        this.centerWidth = this.maxWidth(tCCorner, mCCorner, bCCorner, center, upperColSpan, lowerColSpan);
        this.rightWidth = this.maxWidth(tRCorner, mRCorner, bRCorner, right);
        this.tLCorner = this.adjustString(tLCorner, this.leftWidth);
        this.top = this.adjustString(top, this.horizontalWidth);
        this.tCCorner = this.adjustString(tCCorner, this.centerWidth);
        this.tRCorner = this.adjustString(tRCorner, this.rightWidth);
        this.mLCorner = this.adjustString(mLCorner, this.leftWidth);
        this.middle = this.adjustString(middle, this.horizontalWidth);
        this.mCCorner = this.adjustString(mCCorner, this.centerWidth);
        this.mRCorner = this.adjustString(mRCorner, this.rightWidth);
        this.bLCorner = this.adjustString(bLCorner, this.leftWidth);
        this.bottom = this.adjustString(bottom, this.horizontalWidth);
        this.bCCorner = this.adjustString(bCCorner, this.centerWidth);
        this.bRCorner = this.adjustString(bRCorner, this.rightWidth);
        this.left = this.adjustString(left, this.leftWidth);
        this.center = this.adjustString(center, this.centerWidth);
        this.right = this.adjustString(right, this.rightWidth);
        this.upperColSpan = this.adjustString(upperColSpan, this.centerWidth);
        this.lowerColSpan = this.adjustString(lowerColSpan, this.centerWidth);
    }

    private int maxWidth(String a, String b) {
        return Math.max(this.tileWidth(a), this.tileWidth(b));
    }

    private int maxWidth(String a, String b, String c) {
        return Math.max(Math.max(this.tileWidth(a), this.tileWidth(b)), this.tileWidth(c));
    }

    private int maxWidth(String a, String b, String c, String d) {
        return Math.max(Math.max(Math.max(this.tileWidth(a), this.tileWidth(b)), this.tileWidth(c)), this.tileWidth(d));
    }

    private int maxWidth(String a, String b, String c, String d, String e, String f) {
        return Math.max(this.maxWidth(a, b, c), this.maxWidth(d, e, f));
    }

    private String adjustString(String txt, int width) {
        if (txt == null) {
            return Filler.getFiller(width);
        }
        if (txt.length() == width) {
            return txt;
        }
        if (txt.length() > width) {
            return txt.substring(0, width);
        }
        int diff = width - txt.length();
        return txt + Filler.getFiller(diff);
    }

    private int tileWidth(String tile) {
        if (tile == null) {
            return 0;
        }
        return tile.length();
    }

    public BorderStyle(String customStyle) {
        this.leftWidth = 1;
        this.horizontalWidth = 1;
        this.centerWidth = 1;
        this.rightWidth = 1;
        this.tLCorner = this.get(customStyle, 0);
        this.top = this.get(customStyle, 1);
        this.tCCorner = this.get(customStyle, 2);
        this.tRCorner = this.get(customStyle, 3);
        this.mLCorner = this.get(customStyle, 4);
        this.middle = this.get(customStyle, 5);
        this.mCCorner = this.get(customStyle, 6);
        this.mRCorner = this.get(customStyle, 7);
        this.bLCorner = this.get(customStyle, 8);
        this.bottom = this.get(customStyle, 9);
        this.bCCorner = this.get(customStyle, 10);
        this.bRCorner = this.get(customStyle, 11);
        this.left = this.get(customStyle, 12);
        this.center = this.get(customStyle, 13);
        this.right = this.get(customStyle, 14);
        this.upperColSpan = this.get(customStyle, 15);
        this.lowerColSpan = this.get(customStyle, 16);
    }

    private String get(String style, int index) {
        if (style == null) {
            return DEFAULT_TILE;
        }
        if (index < 0 || index >= style.length()) {
            return DEFAULT_TILE;
        }
        return style.substring(index, index + 1);
    }

    public String getBCCorner() {
        return this.bCCorner;
    }

    public String getBLCorner() {
        return this.bLCorner;
    }

    public String getBottom() {
        return this.bottom;
    }

    public String getBRCorner() {
        return this.bRCorner;
    }

    public String getCenter() {
        return this.center;
    }

    public String getLeft() {
        return this.left;
    }

    public String getMCCorner() {
        return this.mCCorner;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getMLCorner() {
        return this.mLCorner;
    }

    public String getMRCorner() {
        return this.mRCorner;
    }

    public String getRight() {
        return this.right;
    }

    public String getTop() {
        return this.top;
    }

    public String getTCCorner() {
        return this.tCCorner;
    }

    public String getTLCorner() {
        return this.tLCorner;
    }

    public String getTRCorner() {
        return this.tRCorner;
    }

    public String getUpperColSpan() {
        return this.upperColSpan;
    }

    public String getLowerColSpan() {
        return this.lowerColSpan;
    }

    public int getLeftWidth() {
        return this.leftWidth;
    }

    public int getHorizontalWidth() {
        return this.horizontalWidth;
    }

    public int getCenterWidth() {
        return this.centerWidth;
    }

    public int getRightWidth() {
        return this.rightWidth;
    }
}

