/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import org.nocrala.tools.utils.Filler;

public class CellStyle {
    private static final HorizontalAlign DEFAULT_HORIZONTAL_ALIGN = HorizontalAlign.LEFT;
    private static final AbbreviationStyle DEFAULT_ABBREVIATION_STYLE = AbbreviationStyle.DOTS;
    private static final NullStyle DEFAULT_NULL_STYLE = NullStyle.EMPTY_STRING;
    private static final boolean DEFAULT_HANDLE_TERMINAL_FORMATS = true;
    private static final String NULL_TEXT_VALUE = "<null>";
    private static final String DOTS_TEXT = "...";
    private HorizontalAlign horAlign;
    private AbbreviationStyle abbStyle;
    private NullStyle nullStyle;
    private boolean handleTerminalFormats;
    private static final char ESC = '\u001b';
    private static final String FORMAT_RESET_SEQUENCE = "\u001b[0m";

    public CellStyle() {
        this.initialize(DEFAULT_HORIZONTAL_ALIGN, DEFAULT_ABBREVIATION_STYLE, DEFAULT_NULL_STYLE, true);
    }

    public CellStyle(HorizontalAlign horAlign) {
        this.initialize(horAlign, DEFAULT_ABBREVIATION_STYLE, DEFAULT_NULL_STYLE, true);
    }

    public CellStyle(HorizontalAlign horAlign, AbbreviationStyle abbStyle) {
        this.initialize(horAlign, abbStyle, DEFAULT_NULL_STYLE, true);
    }

    public CellStyle(HorizontalAlign horAlign, AbbreviationStyle abbStyle, NullStyle nullStyle) {
        this.initialize(horAlign, abbStyle, nullStyle, true);
    }

    public CellStyle(HorizontalAlign horAlign, AbbreviationStyle abbStyle, NullStyle nullStyle, boolean handleTerminalFormats) {
        this.initialize(horAlign, abbStyle, nullStyle, handleTerminalFormats);
    }

    private void initialize(HorizontalAlign horAlign, AbbreviationStyle abbStyle, NullStyle nullStyle, boolean handleTerminalFormats) {
        this.horAlign = horAlign;
        this.abbStyle = abbStyle;
        this.nullStyle = nullStyle;
        this.handleTerminalFormats = handleTerminalFormats;
    }

    private String renderUncroppedText(String txt) {
        if (txt == null) {
            if (NullStyle.EMPTY_STRING.equals((Object)this.nullStyle)) {
                return "";
            }
            return NULL_TEXT_VALUE;
        }
        return txt;
    }

    public int getWidth(String txt) {
        String content = this.handleTerminalFormats && txt != null ? this.removeTerminalFormats(txt) : txt;
        return this.renderUncroppedText(content).length();
    }

    private String removeTerminalFormats(String txt) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < txt.length()) {
            int esc = txt.indexOf(27, i);
            if (esc == -1) {
                sb.append(txt.substring(i));
                return sb.toString();
            }
            int m = txt.indexOf(109, esc);
            if (m == -1) {
                return sb.toString();
            }
            sb.append(txt.substring(i, esc));
            i = m + 1;
        }
        return sb.toString();
    }

    public String render(String txt, int width) {
        String plainText = this.renderUncroppedText(txt);
        String uc = this.renderUnclosedContent(txt, width, plainText);
        if (this.handleTerminalFormats && uc.indexOf("[") != -1) {
            return uc + FORMAT_RESET_SEQUENCE;
        }
        return uc;
    }

    private String renderUnclosedContent(String txt, int width, String plainText) {
        int tWidth = this.getWidth(txt);
        if (tWidth < width) {
            switch (this.horAlign) {
                case LEFT: {
                    return this.alignLeft(plainText, width);
                }
                case CENTER: {
                    return this.alignCenter(plainText, width);
                }
            }
            return this.alignRight(plainText, width);
        }
        if (tWidth == width) {
            return plainText;
        }
        switch (this.abbStyle) {
            case CROP: {
                return this.abbreviateCrop(plainText, width);
            }
        }
        return this.abbreviateDots(plainText, width);
    }

    private String alignLeft(String txt, int width) {
        int diff = width - this.getWidth(txt);
        return txt + Filler.getFiller(diff);
    }

    private String alignCenter(String txt, int width) {
        int diff = width - this.getWidth(txt);
        int diffLeft = diff / 2;
        int diffRight = diff - diffLeft;
        return Filler.getFiller(diffLeft) + txt + Filler.getFiller(diffRight);
    }

    private String alignRight(String txt, int width) {
        int diff = width - this.getWidth(txt);
        return Filler.getFiller(diff) + txt;
    }

    private String abbreviateCrop(String txt, int width) {
        int len = this.getLength(txt, width);
        return txt.substring(0, len);
    }

    private int getLength(String txt, int width) {
        int added = 0;
        int i = 0;
        while (i < txt.length() && added <= width) {
            char c = txt.charAt(i);
            if (c == '\u001b') {
                int m = txt.indexOf(109, i);
                if (m == -1) {
                    i = txt.length();
                    continue;
                }
                i = m + 1;
                continue;
            }
            if (added < width) {
                ++i;
                ++added;
                continue;
            }
            return i;
        }
        return i;
    }

    private String abbreviateDots(String txt, int width) {
        if (width < 1) {
            return "";
        }
        if (width <= DOTS_TEXT.length()) {
            return DOTS_TEXT.substring(0, width);
        }
        return this.abbreviateCrop(txt, width - DOTS_TEXT.length()) + DOTS_TEXT;
    }

    static String renderNullCell(int width) {
        return Filler.getFiller(width);
    }

    public static enum NullStyle {
        EMPTY_STRING,
        NULL_TEXT;

    }

    public static enum AbbreviationStyle {
        CROP,
        DOTS;

    }

    public static enum HorizontalAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

