/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.Column;
import org.nocrala.tools.texttablefmt.Row;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.TableStyle;
import org.nocrala.tools.utils.Log;

public class StreamingTable {
    private static final int DEFAULT_WIDTH = 10;
    private Appendable appendable;
    TableStyle tableStyle;
    private List<Column> columns;
    private int currentColumn;
    private Row previousRow;
    private Row currentRow;
    private int currentRowPos;

    public StreamingTable(Appendable appendable, int totalColumns) {
        this.initialize(appendable, totalColumns);
        this.tableStyle = new TableStyle(BorderStyle.CLASSIC, ShownBorders.SURROUND_HEADER_AND_COLUMNS, false, 0, null);
    }

    public StreamingTable(Appendable appendable, int totalColumns, BorderStyle borderStyle) {
        this.initialize(appendable, totalColumns);
        this.tableStyle = new TableStyle(borderStyle, ShownBorders.SURROUND_HEADER_AND_COLUMNS, false, 0, null);
    }

    public StreamingTable(Appendable appendable, int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders) {
        this.initialize(appendable, totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, false, 0, null);
    }

    public StreamingTable(Appendable appendable, int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml) {
        this.initialize(appendable, totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, escapeXml, 0, null);
    }

    public StreamingTable(Appendable appendable, int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml, int leftMargin) {
        this.initialize(appendable, totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, escapeXml, leftMargin, null);
    }

    public StreamingTable(Appendable appendable, int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml, String prompt) {
        this.initialize(appendable, totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, escapeXml, 0, prompt);
    }

    private void initialize(Appendable writer, int totalColumns) {
        this.appendable = writer;
        this.previousRow = null;
        this.columns = new ArrayList<Column>();
        for (int i = 0; i < totalColumns; ++i) {
            this.columns.add(new Column(i, 10));
        }
        this.currentColumn = 0;
        this.currentRow = null;
        this.currentRowPos = 0;
    }

    public void setColumnWidth(int col, int width) {
        this.columns.get(col).setWidth(width < 0 ? 0 : width);
    }

    public void addCell(String content) throws IOException {
        this.addCell(content, new CellStyle());
    }

    public void addCell(String content, int colSpan) throws IOException {
        this.addCell(content, new CellStyle(), colSpan);
    }

    public void addCell(String content, CellStyle style) throws IOException {
        this.addCell(content, style, 1);
    }

    public void addCell(String content, CellStyle style, int colSpan) throws IOException {
        if (this.currentRow == null) {
            this.currentRow = new Row();
            this.currentColumn = 0;
        }
        if (this.currentColumn >= this.columns.size()) {
            this.renderRow(false);
            this.previousRow = this.currentRow;
            this.currentRow = new Row();
            this.currentColumn = 0;
        }
        int adjColSpan = colSpan > 0 ? colSpan : 1;
        this.currentRow.addCell(content, style, adjColSpan);
        this.currentColumn += adjColSpan;
    }

    public void finishTable() throws IOException {
        if (this.currentRow != null) {
            this.renderRow(true);
        }
    }

    private void renderRow(boolean isLast) throws IOException {
        Log.debug("this.currentRow.getSize()=" + this.currentRow.getSize());
        boolean isFirst = this.currentRowPos == 0;
        boolean isSecond = this.currentRowPos == 1;
        boolean isIntermediate = this.currentRowPos > 1 && !isLast;
        this.tableStyle.renderRow(this.appendable, this.currentRow, this.previousRow, this.columns, isFirst, isSecond, isIntermediate, isLast);
        ++this.currentRowPos;
    }

    int getTotalColumns() {
        return this.columns.size();
    }

    Column getColumn(int index) {
        return this.columns.get(index);
    }
}

