/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import java.util.ArrayList;
import java.util.List;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.Cell;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.Column;
import org.nocrala.tools.texttablefmt.Row;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.TableStyle;
import org.nocrala.tools.utils.Log;

public class Table {
    private static final int DEFAULT_MIN_WIDTH = 0;
    private static final int DEFAULT_MAX_WIDTH = Integer.MAX_VALUE;
    TableStyle tableStyle;
    private List<Row> rows;
    private List<Column> columns;
    private int totalColumns;
    private int currentColumn;
    private Row currentRow;

    public Table(int totalColumns) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(BorderStyle.CLASSIC, ShownBorders.SURROUND_HEADER_AND_COLUMNS, false, 0, null);
    }

    public Table(int totalColumns, BorderStyle borderStyle) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(borderStyle, ShownBorders.SURROUND_HEADER_AND_COLUMNS, false, 0, null);
    }

    public Table(int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, false, 0, null);
    }

    public Table(int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, escapeXml, 0, null);
    }

    public Table(int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml, int leftMargin) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, escapeXml, leftMargin, null);
    }

    public Table(int totalColumns, BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml, String prompt) {
        this.initialize(totalColumns);
        this.tableStyle = new TableStyle(borderStyle, shownBorders, escapeXml, 0, prompt);
    }

    private void initialize(int totalColumns) {
        this.totalColumns = totalColumns;
        this.rows = new ArrayList<Row>();
        this.columns = new ArrayList<Column>();
        for (int i = 0; i < this.totalColumns; ++i) {
            this.columns.add(new Column(i, 0, Integer.MAX_VALUE));
        }
        this.currentColumn = 0;
        this.currentRow = null;
    }

    public void setColumnWidth(int col, int minWidth, int maxWidth) {
        this.columns.get(col).setWidthRange(minWidth, maxWidth);
    }

    public void addCell(String content) {
        this.addCell(content, new CellStyle());
    }

    public void addCell(String content, int colSpan) {
        this.addCell(content, new CellStyle(), colSpan);
    }

    public void addCell(String content, CellStyle style) {
        this.addCell(content, style, 1);
    }

    public void addCell(String content, CellStyle style, int colSpan) {
        int adjColSpan;
        if (this.currentRow == null || this.currentColumn >= this.totalColumns) {
            this.currentRow = new Row();
            this.rows.add(this.currentRow);
            this.currentColumn = 0;
        }
        int n = adjColSpan = colSpan > 0 ? colSpan : 1;
        if (this.currentColumn + adjColSpan > this.totalColumns) {
            adjColSpan = this.totalColumns - this.currentColumn;
        }
        this.currentRow.addCell(content, style, adjColSpan);
        this.currentColumn += adjColSpan;
    }

    public String render() {
        this.calculateColumnsWidth();
        return this.tableStyle.renderTable(this);
    }

    public String[] renderAsStringArray() {
        this.calculateColumnsWidth();
        return this.tableStyle.renderAsStringArray(this);
    }

    int getTotalColumns() {
        return this.totalColumns;
    }

    private void calculateColumnsWidth() {
        for (Row r : this.rows) {
            int startCol = 0;
            for (Cell cell : r.getCells()) {
                int endCol = startCol + cell.getColSpan() - 1;
                try {
                    Column col = this.columns.get(endCol);
                    col.add(cell);
                    startCol += cell.getColSpan();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
        for (Column col : this.columns) {
            col.calculateWidth(this.columns, this.tableStyle.borderStyle.getTCCorner().length());
            Log.debug("width=" + col.getColumnWidth());
        }
    }

    List<Row> getRows() {
        return this.rows;
    }

    List<Column> getColumns() {
        return this.columns;
    }
}

