#!/bin/bash
# Program:
#	script to config core dump output path

CORE_PATTERN_FILE=/proc/sys/kernel/core_pattern

if [ "$1" != "--silent" ]; then
	value=`cat ${CORE_PATTERN_FILE}`

	if [ "${value:0:1}" = "|" ];
	then
		echo "Instead of writing the core dump to disk, your system is configured to send it to the \"$value\" instead."
	else
		echo "The current core dump file name is \"$value\"." 
	fi
	echo "Do you want to modify the core dump file name?"
	read -p " (yes) or (no):" selection

	if [ $selection == "yes" ] || [ $selection == "y" ]; 
		then :
	else
		exit 1
	fi
fi

CORE_FILE="/tmp/core_zoom_%p"

echo "Do you want to specify a core dump file name or use the default one?"

function specify_file_name()
{
	read -p "Please specify core dump file name:" CORE_FILE
	if [ "${CORE_FILE:0:1}" = "/" ]; then
		echo "The core dump file name is $CORE_FILE"
		echo $CORE_FILE > $CORE_PATTERN_FILE
		exit 0
	fi
	echo "Invalid file name! File name must start with an absolute path"
	specify_file_name
}
#$1 user selection
function handle_selection()
{
	echo "    (1) Default core dump file name(/tmp/core_zoom_%p)"
	echo "    (2) Specify a file name(file name must start with an absolute path)"
	read -p "Your selection?" selection

	if [ $selection == "1" ] || [ $selection == "(1)" ]; then
		echo $CORE_FILE > $CORE_PATTERN_FILE
	elif [ $selection == "2" ] || [ $selection == "(2)" ]; then
		specify_file_name
	else
		echo "Invalid selection"
		handle_selection
	fi
}

handle_selection