#!/bin/sh

echo =============================================================================================
echo This is debug mode of zoom client. Once crash, zoom will generate core dump under this mode.
echo =============================================================================================

CORE_PATTERN_FILE=/proc/sys/kernel/core_pattern
value=`cat ${CORE_PATTERN_FILE}`

grep -q '^|' "${CORE_PATTERN_FILE}" && echo "Instead of writing the core dump to disk, your system is configured to send it to the \"$value\" instead." || echo "The current core dump file is \"$value\"."

echo "Do you want to modify the default core dump file name?"

read -p " (yes) or (no):" selection

if [ $selection = "yes" ] || [ $selection = "y" ]; then
	echo "sudo..."
	if sudo bash config-dump.sh --silent;
		then :
	else
		echo "Error!!! Please run \"config-dump.sh\" under root privilege to modify core dump file name"
		exit 1
	fi
fi

echo "current user role:"
whoami

appname=`basename $0 | sed s,\.sh$,,`

dirname=`dirname $0`
tmp="${dirname#?}"

if [ "${dirname%$tmp}" != "/" ]; then
dirname=$PWD/$dirname
fi
#LD_LIBRARY_PATH=$dirname/Qt/lib
LD_LIBRARY_PATH=$dirname
export LD_LIBRARY_PATH
echo $LD_LIBRARY_PATH
ulimit -c unlimited
$dirname/$appname "$@"
